/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.db.DefaultDBColumn;
import adql.parser.ParseException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLOrder;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.search.ISearchHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ADQLQuery
implements ADQLObject {
    private ClauseSelect select;
    private FromContent from;
    private ClauseConstraints where;
    private ClauseADQL<ColumnReference> groupBy;
    private ClauseConstraints having;
    private ClauseADQL<ADQLOrder> orderBy;

    public ADQLQuery() {
        this.select = new ClauseSelect();
        this.from = null;
        this.where = new ClauseConstraints("WHERE");
        this.groupBy = new ClauseADQL("GROUP BY");
        this.having = new ClauseConstraints("HAVING");
        this.orderBy = new ClauseADQL("ORDER BY");
    }

    public ADQLQuery(ADQLQuery aDQLQuery) throws Exception {
        this.select = (ClauseSelect)aDQLQuery.select.getCopy();
        this.from = (FromContent)aDQLQuery.from.getCopy();
        this.where = (ClauseConstraints)aDQLQuery.where.getCopy();
        this.groupBy = (ClauseADQL)aDQLQuery.groupBy.getCopy();
        this.having = (ClauseConstraints)aDQLQuery.having.getCopy();
        this.orderBy = (ClauseADQL)aDQLQuery.orderBy.getCopy();
    }

    public void reset() {
        this.select.clear();
        this.select.setDistinctColumns(false);
        this.select.setNoLimit();
        this.from = null;
        this.where.clear();
        this.groupBy.clear();
        this.having.clear();
        this.orderBy.clear();
    }

    public final ClauseSelect getSelect() {
        return this.select;
    }

    public void setSelect(ClauseSelect clauseSelect) throws NullPointerException {
        if (clauseSelect == null) {
            throw new NullPointerException("Impossible to replace the SELECT clause of a query by NULL !");
        }
        this.select = clauseSelect;
    }

    public final FromContent getFrom() {
        return this.from;
    }

    public void setFrom(FromContent fromContent) throws NullPointerException {
        if (fromContent == null) {
            throw new NullPointerException("Impossible to replace the FROM clause of a query by NULL !");
        }
        this.from = fromContent;
    }

    public final ClauseConstraints getWhere() {
        return this.where;
    }

    public void setWhere(ClauseConstraints clauseConstraints) throws NullPointerException {
        if (clauseConstraints == null) {
            this.where.clear();
        } else {
            this.where = clauseConstraints;
        }
    }

    public final ClauseADQL<ColumnReference> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(ClauseADQL<ColumnReference> clauseADQL) throws NullPointerException {
        if (clauseADQL == null) {
            this.groupBy.clear();
        } else {
            this.groupBy = clauseADQL;
        }
    }

    public final ClauseConstraints getHaving() {
        return this.having;
    }

    public void setHaving(ClauseConstraints clauseConstraints) throws NullPointerException {
        if (clauseConstraints == null) {
            this.having.clear();
        } else {
            this.having = clauseConstraints;
        }
    }

    public final ClauseADQL<ADQLOrder> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(ClauseADQL<ADQLOrder> clauseADQL) throws NullPointerException {
        if (clauseADQL == null) {
            this.orderBy.clear();
        } else {
            this.orderBy = clauseADQL;
        }
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLQuery(this);
    }

    @Override
    public String getName() {
        return "{ADQL query}";
    }

    public DBColumn[] getResultingColumns() {
        ArrayList<DBColumn> arrayList = new ArrayList<DBColumn>(this.select.size());
        for (SelectItem selectItem : this.select) {
            ADQLOperand aDQLOperand = selectItem.getOperand();
            if (selectItem instanceof SelectAllColumns) {
                try {
                    if (((SelectAllColumns)selectItem).getAdqlTable() != null) {
                        arrayList.addAll(((SelectAllColumns)selectItem).getAdqlTable().getDBColumns());
                        continue;
                    }
                    arrayList.addAll(this.from.getDBColumns());
                }
                catch (ParseException parseException) {}
                continue;
            }
            DBColumn dBColumn = null;
            if (selectItem.hasAlias()) {
                if (aDQLOperand instanceof ADQLColumn && ((ADQLColumn)aDQLOperand).getDBLink() != null) {
                    dBColumn = ((ADQLColumn)aDQLOperand).getDBLink();
                    dBColumn = dBColumn.copy(dBColumn.getDBName(), selectItem.getAlias(), dBColumn.getTable());
                } else {
                    dBColumn = new DefaultDBColumn(selectItem.getAlias(), null);
                }
            } else {
                if (aDQLOperand instanceof ADQLColumn && ((ADQLColumn)aDQLOperand).getDBLink() != null) {
                    dBColumn = ((ADQLColumn)aDQLOperand).getDBLink();
                }
                if (dBColumn == null) {
                    dBColumn = new DefaultDBColumn(selectItem.getName(), null);
                }
            }
            arrayList.add(dBColumn);
        }
        DBColumn[] dBColumnArray = new DBColumn[arrayList.size()];
        return arrayList.toArray(dBColumnArray);
    }

    public Iterator<ADQLObject> search(ISearchHandler iSearchHandler) {
        iSearchHandler.search(this);
        return iSearchHandler.iterator();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private ClauseADQL<?> currentClause = null;

            @Override
            public ADQLObject next() {
                ++this.index;
                switch (this.index) {
                    case 0: {
                        this.currentClause = ADQLQuery.this.select;
                        break;
                    }
                    case 1: {
                        this.currentClause = null;
                        return ADQLQuery.this.from;
                    }
                    case 2: {
                        this.currentClause = ADQLQuery.this.where;
                        break;
                    }
                    case 3: {
                        this.currentClause = ADQLQuery.this.groupBy;
                        break;
                    }
                    case 4: {
                        this.currentClause = ADQLQuery.this.having;
                        break;
                    }
                    case 5: {
                        this.currentClause = ADQLQuery.this.orderBy;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException();
                    }
                }
                return this.currentClause;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 6;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else {
                    switch (this.index) {
                        case 0: {
                            if (aDQLObject instanceof ClauseSelect) {
                                ADQLQuery.this.select = (ClauseSelect)aDQLObject;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseSelect (" + ADQLQuery.this.select.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                        }
                        case 1: {
                            if (aDQLObject instanceof FromContent) {
                                ADQLQuery.this.from = (FromContent)aDQLObject;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a FromContent (" + ADQLQuery.this.from.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                        }
                        case 2: {
                            if (aDQLObject instanceof ClauseConstraints) {
                                ADQLQuery.this.where = (ClauseConstraints)aDQLObject;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseConstraints (" + ADQLQuery.this.where.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                        }
                        case 3: {
                            if (aDQLObject instanceof ClauseADQL) {
                                ADQLQuery.this.groupBy = (ClauseADQL)aDQLObject;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + ADQLQuery.this.groupBy.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                        }
                        case 4: {
                            if (aDQLObject instanceof ClauseConstraints) {
                                ADQLQuery.this.having = (ClauseConstraints)aDQLObject;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseConstraints (" + ADQLQuery.this.having.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                        }
                        case 5: {
                            if (aDQLObject instanceof ClauseADQL) {
                                ADQLQuery.this.orderBy = (ClauseADQL)aDQLObject;
                                break;
                            }
                            throw new UnsupportedOperationException("Impossible to replace a ClauseADQL (" + ADQLQuery.this.orderBy.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                        }
                    }
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                if (this.index == 0 || this.index == 1) {
                    throw new UnsupportedOperationException("Impossible to remove a " + (this.index == 0 ? "SELECT" : "FROM") + " clause from a query !");
                }
                this.currentClause.clear();
            }
        };
    }

    @Override
    public String toADQL() {
        StringBuffer stringBuffer = new StringBuffer(this.select.toADQL());
        stringBuffer.append("\nFROM ").append(this.from.toADQL());
        if (!this.where.isEmpty()) {
            stringBuffer.append('\n').append(this.where.toADQL());
        }
        if (!this.groupBy.isEmpty()) {
            stringBuffer.append('\n').append(this.groupBy.toADQL());
        }
        if (!this.having.isEmpty()) {
            stringBuffer.append('\n').append(this.having.toADQL());
        }
        if (!this.orderBy.isEmpty()) {
            stringBuffer.append('\n').append(this.orderBy.toADQL());
        }
        return stringBuffer.toString();
    }
}

